(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(factory((global.weekstart = {})));
}(this, (function (exports) { 'use strict';

function getWeekStartByRegion(regionCode, regionDayMap) {
    var code = regionDayMap[typeof regionCode === 'string' ? regionCode.toUpperCase() : regionCode];
    return typeof code === 'number' ? code : 1;
}

function getWeekStartByLocale(locale, langRegionMap, regionDayMap) {
    if (locale) {
        var data = locale.toLowerCase().split(/[-_]/);
        var language = data[0];
        var country;
        if (data[1] && data[1].length === 4) {
            language += "_" + (data[1]);
            country = data[2];
        } else {
            country = data[1];
        }
        if (!country) {
            country = langRegionMap[language];
        }
        if (country) {
            return getWeekStartByRegion(country.match(/^\d+$/) ? Number(country) : country, regionDayMap);
        }
    }
    return 1;
}



//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

var langRegionMap = {
    en: 'US',
    zh: 'CN',
    zh_hans: 'CN',
    hans: 'CN',
    wuu: 'CN',
    hsn: 'CN',
    hak: 'CN',
    nan: 'CN',
    gan: 'CN',
    ii: 'CN',
    ug: 'CN',
    ug_arab: 'CN',
    za: 'CN',
    mn_mong: 'CN',
    bo: 'CN',
    kk_arab: 'CN',
    lis: 'CN',
    ky_arab: 'CN',
    nxq: 'CN',
    tdd: 'CN',
    khb: 'CN',
    lcp: 'CN',
    hi: 'IN',
    te: 'IN',
    mr: 'IN',
    ta: 'IN',
    gu: 'IN',
    kn: 'IN',
    or: 'IN',
    ml: 'IN',
    pa_guru: 'IN',
    bho: 'IN',
    awa: 'IN',
    as: 'IN',
    mwr: 'IN',
    mai: 'IN',
    mag: 'IN',
    bgc: 'IN',
    hne: 'IN',
    dcc: 'IN',
    bjj: 'IN',
    sat: 'IN',
    wtm: 'IN',
    ks: 'IN',
    ks_arab: 'IN',
    kok: 'IN',
    gom: 'IN',
    swv: 'IN',
    lmn: 'IN',
    gbm: 'IN',
    gon: 'IN',
    gon_telu: 'IN',
    kfy: 'IN',
    kru: 'IN',
    doi: 'IN',
    wbq: 'IN',
    sck: 'IN',
    xnr: 'IN',
    wbr: 'IN',
    tcy: 'IN',
    khn: 'IN',
    brx: 'IN',
    noe: 'IN',
    bhb: 'IN',
    mni: 'IN',
    raj: 'IN',
    hoc: 'IN',
    mtr: 'IN',
    unr: 'IN',
    unr_beng: 'IN',
    bhi: 'IN',
    hoj: 'IN',
    kha: 'IN',
    kfr: 'IN',
    grt: 'IN',
    unx: 'IN',
    unx_beng: 'IN',
    bfy: 'IN',
    srx: 'IN',
    saz: 'IN',
    sd_deva: 'IN',
    njo: 'IN',
    bjq: 'IN',
    ria: 'IN',
    bpy: 'IN',
    bra: 'IN',
    lep: 'IN',
    sa: 'IN',
    kht: 'IN',
    kgp: 'BR',
    gub: 'BR',
    yrl: 'BR',
    xav: 'BR',
    dz: 'BT',
    tn: 'BW',
    pdt: 'CA',
    crk: 'CA',
    cr: 'CA',
    cr_cans: 'CA',
    iu: 'CA',
    iu_cans: 'CA',
    iu_latn: 'CA',
    moe: 'CA',
    crj: 'CA',
    atj: 'CA',
    crl: 'CA',
    csw: 'CA',
    crm: 'CA',
    ikt: 'CA',
    moh: 'CA',
    dgr: 'CA',
    den: 'CA',
    scs: 'CA',
    nsk: 'CA',
    chp: 'CA',
    gwi: 'CA',
    guc: 'CO',
    am: 'ET',
    om: 'ET',
    ti: 'ET',
    sid: 'ET',
    wal: 'ET',
    aa: 'ET',
    quc: 'GT',
    ch: 'GU',
    id: 'ID',
    jv: 'ID',
    su: 'ID',
    mad: 'ID',
    ms_arab: 'ID',
    min: 'ID',
    bew: 'ID',
    ban: 'ID',
    bug: 'ID',
    bjn: 'ID',
    ace: 'ID',
    sas: 'ID',
    bbc: 'ID',
    mak: 'ID',
    ljp: 'ID',
    rej: 'ID',
    gor: 'ID',
    nij: 'ID',
    kge: 'ID',
    aoz: 'ID',
    kvr: 'ID',
    lbw: 'ID',
    gay: 'ID',
    rob: 'ID',
    sxn: 'ID',
    mdr: 'ID',
    sly: 'ID',
    mwv: 'ID',
    ga: 'IE',
    he: 'IL',
    lad: 'IL',
    jam: 'JM',
    ja: 'JP',
    ryu: 'JP',
    ki: 'KE',
    luy: 'KE',
    luo: 'KE',
    kln: 'KE',
    kam: 'KE',
    guz: 'KE',
    mer: 'KE',
    ebu: 'KE',
    dav: 'KE',
    pko: 'KE',
    saq: 'KE',
    km: 'KH',
    cja: 'KH',
    ko: 'KR',
    lo: 'LA',
    kjg: 'LA',
    mh: 'MH',
    my: 'MM',
    shn: 'MM',
    kac: 'MM',
    mnw: 'MM',
    mt: 'MT',
    yua: 'MX',
    nhe: 'MX',
    nhw: 'MX',
    maz: 'MX',
    nch: 'MX',
    sei: 'MX',
    vmw: 'MZ',
    ndc: 'MZ',
    ngl: 'MZ',
    seh: 'MZ',
    mgh: 'MZ',
    rng: 'MZ',
    yao: 'MZ',
    ne: 'NP',
    'new': 'NP',
    jml: 'NP',
    taj: 'NP',
    thl: 'NP',
    bap: 'NP',
    tdg: 'NP',
    thr: 'NP',
    mgp: 'NP',
    lif: 'NP',
    lif_deva: 'NP',
    thq: 'NP',
    mrd: 'NP',
    xsr: 'NP',
    rjs: 'NP',
    tsf: 'NP',
    ggn: 'NP',
    gvr: 'NP',
    tkt: 'NP',
    tdh: 'NP',
    unr_deva: 'NP',
    mi: 'NZ',
    qu: 'PE',
    fil: 'PH',
    ceb: 'PH',
    ilo: 'PH',
    hil: 'PH',
    bik: 'PH',
    war: 'PH',
    pam: 'PH',
    bhk: 'PH',
    pag: 'PH',
    mdh: 'PH',
    tsg: 'PH',
    cps: 'PH',
    krj: 'PH',
    bto: 'PH',
    hnn: 'PH',
    tbw: 'PH',
    bku: 'PH',
    ur: 'PK',
    pa: 'PK',
    pa_arab: 'PK',
    arab: 'PK',
    lah: 'PK',
    ps: 'PK',
    sd: 'PK',
    sd_arab: 'PK',
    skr: 'PK',
    bal: 'PK',
    brh: 'PK',
    hno: 'PK',
    bgn: 'PK',
    hnd: 'PK',
    tg_arab: 'PK',
    gju: 'PK',
    bft: 'PK',
    kvx: 'PK',
    khw: 'PK',
    mvy: 'PK',
    kxp: 'PK',
    gjk: 'PK',
    btv: 'PK',
    gn: 'PY',
    th: 'TH',
    tts: 'TH',
    nod: 'TH',
    sou: 'TH',
    mfa: 'TH',
    kxm: 'TH',
    kdt: 'TH',
    lwl: 'TH',
    aeb: 'TN',
    zh_hant: 'TW',
    hant: 'TW',
    trv: 'TW',
    nv: 'US',
    pdc: 'US',
    haw: 'US',
    frc: 'US',
    chr: 'US',
    esu: 'US',
    dak: 'US',
    cho: 'US',
    lkt: 'US',
    ik: 'US',
    mus: 'US',
    sm: 'WS',
    zu: 'ZA',
    xh: 'ZA',
    af: 'ZA',
    nso: 'ZA',
    st: 'ZA',
    ts: 'ZA',
    ss: 'ZA',
    ve: 'ZA',
    nr: 'ZA',
    sn: 'ZW',
    nd: 'ZW',
    mxc: 'ZW',
    kck: 'ZW',
    haz: 'AF',
    uz_arab: 'AF',
    arq: 'DZ',
    kab: 'DZ',
    ar: 'EG',
    arz: 'EG',
    ckb: 'IQ',
    syr: 'IQ',
    fa: 'IR',
    az_arab: 'IR',
    mzn: 'IR',
    glk: 'IR',
    sdh: 'IR',
    lrc: 'IR',
    rmt: 'IR',
    bqi: 'IR',
    luz: 'IR',
    lki: 'IR',
    prd: 'IR',
    gbz: 'IR',
    ary: 'MA',
    zgh: 'MA',
    tzm: 'MA',
    tzm_latn: 'MA',
    shi: 'MA',
    shi_latn: 'MA',
    shi_tfng: 'MA',
    tfng: 'MA',
    rif: 'MA',
    rif_latn: 'MA',
    rif_tfng: 'MA',
    bej: 'SD',
    fvr: 'SD',
    mls: 'SD',
    fia: 'SD',
    zag: 'SD',
    bn: 'BD',
    rkt: 'BD',
    syl: 'BD',
    ccp: 'BD',
    dv: 'MV'
};

var regionDayMap = {
    AG: 0,
    ATG: 0,
    28: 0,
    AR: 0,
    ARG: 0,
    32: 0,
    AS: 0,
    ASM: 0,
    16: 0,
    AU: 0,
    AUS: 0,
    36: 0,
    BR: 0,
    BRA: 0,
    76: 0,
    BS: 0,
    BHS: 0,
    44: 0,
    BT: 0,
    BTN: 0,
    64: 0,
    BW: 0,
    BWA: 0,
    72: 0,
    BZ: 0,
    BLZ: 0,
    84: 0,
    CA: 0,
    CAN: 0,
    124: 0,
    CN: 0,
    CHN: 0,
    156: 0,
    CO: 0,
    COL: 0,
    170: 0,
    DM: 0,
    DMA: 0,
    212: 0,
    DO: 0,
    DOM: 0,
    214: 0,
    ET: 0,
    ETH: 0,
    231: 0,
    GT: 0,
    GTM: 0,
    320: 0,
    GU: 0,
    GUM: 0,
    316: 0,
    HK: 0,
    HKG: 0,
    344: 0,
    HN: 0,
    HND: 0,
    340: 0,
    ID: 0,
    IDN: 0,
    360: 0,
    IE: 0,
    IRL: 0,
    372: 0,
    IL: 0,
    ISR: 0,
    376: 0,
    IN: 0,
    IND: 0,
    356: 0,
    JM: 0,
    JAM: 0,
    388: 0,
    JP: 0,
    JPN: 0,
    392: 0,
    KE: 0,
    KEN: 0,
    404: 0,
    KH: 0,
    KHM: 0,
    116: 0,
    KR: 0,
    KOR: 0,
    410: 0,
    LA: 0,
    LA0: 0,
    418: 0,
    MH: 0,
    MHL: 0,
    584: 0,
    MM: 0,
    MMR: 0,
    104: 0,
    MO: 0,
    MAC: 0,
    446: 0,
    MT: 0,
    MLT: 0,
    470: 0,
    MX: 0,
    MEX: 0,
    484: 0,
    MZ: 0,
    MOZ: 0,
    508: 0,
    NI: 0,
    NIC: 0,
    558: 0,
    NP: 0,
    NPL: 0,
    524: 0,
    NZ: 0,
    NZL: 0,
    554: 0,
    PA: 0,
    PAN: 0,
    591: 0,
    PE: 0,
    PER: 0,
    604: 0,
    PH: 0,
    PHL: 0,
    608: 0,
    PK: 0,
    PAK: 0,
    586: 0,
    PR: 0,
    PRI: 0,
    630: 0,
    PY: 0,
    PRY: 0,
    600: 0,
    SA: 0,
    SAU: 0,
    682: 0,
    SG: 0,
    SGP: 0,
    702: 0,
    SV: 0,
    SLV: 0,
    222: 0,
    TH: 0,
    THA: 0,
    764: 0,
    TN: 0,
    TUN: 0,
    788: 0,
    TT: 0,
    TTO: 0,
    780: 0,
    TW: 0,
    TWN: 0,
    158: 0,
    UM: 0,
    UMI: 0,
    581: 0,
    US: 0,
    USA: 0,
    840: 0,
    VE: 0,
    VEN: 0,
    862: 0,
    VI: 0,
    VIR: 0,
    850: 0,
    WS: 0,
    WSM: 0,
    882: 0,
    YE: 0,
    YEM: 0,
    887: 0,
    ZA: 0,
    ZAF: 0,
    710: 0,
    ZW: 0,
    ZWE: 0,
    716: 0,
    AE: 6,
    ARE: 6,
    784: 6,
    AF: 6,
    AFG: 6,
    4: 6,
    BH: 6,
    BHR: 6,
    48: 6,
    DJ: 6,
    DJI: 6,
    262: 6,
    DZ: 6,
    DZA: 6,
    12: 6,
    EG: 6,
    EGY: 6,
    818: 6,
    IQ: 6,
    IRQ: 6,
    368: 6,
    IR: 6,
    IRN: 6,
    364: 6,
    JO: 6,
    JOR: 6,
    400: 6,
    KW: 6,
    KWT: 6,
    414: 6,
    LY: 6,
    LBY: 6,
    434: 6,
    MA: 6,
    MAR: 6,
    504: 6,
    OM: 6,
    OMN: 6,
    512: 6,
    QA: 6,
    QAT: 6,
    634: 6,
    SD: 6,
    SDN: 6,
    729: 6,
    SY: 6,
    SYR: 6,
    760: 6,
    BD: 5,
    BGD: 5,
    50: 5,
    MV: 5,
    MDV: 5,
    462: 5
};



//# sourceMappingURL=data:application/json;charset=utf-8;base64,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

function getWeekStartByRegion$1(regionCode) {
    return getWeekStartByRegion(regionCode, regionDayMap);
}

function getWeekStartByLocale$1(locale) {
    return getWeekStartByLocale(locale, langRegionMap, regionDayMap);
}

exports.getWeekStartByRegion = getWeekStartByRegion$1;
exports.getWeekStartByLocale = getWeekStartByLocale$1;

})));
//# sourceMappingURL=full.js.map
